package com.vmware.samples.chassisservice;

import com.vmware.samples.chassisservice.model.ChassisInfo;

/**
 * Interface to perform operations on the Chassis object.
 */
public interface ChassisService {
   /**
    * Creates a new chassis with the given chassisInfo values.
    *
    * @param chassisInfo
    *    Chassis data used to create new Chassis.
    *
    * @return
    *    Returns the reference of the newly created Chassis,
    *    or null if the creation failed because the name was already taken.
    */
   Object createChassis(ChassisInfo chassisInfo);

   /**
    * Edits the given chassis object.
    *
    * @param chassisReference Chassis reference.
    * @return true if the Chassis was edited successfully.
    */
   boolean editChassis(Object chassisReference);

   /**
    * Deletes the given chassis object.
    *
    * @param chassisReference Chassis reference.
    * @return true if the Chassis was deleted successfully.
    */
   boolean deleteChassis(Object chassisReference);

}
